﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// [Toni Sanio @2015]

namespace DebtAversion
{

    // Math.Truncate(50.947563 * 100) / 100; <- it will leave two decimals in the number without rounding
    // string s = string.Format("{0:N2}", x);  <- the same thing.. scare of getting rounded.
    // this will round the number String.Format("{0:0.00}", num);

    class Utils
    {

        public static double getTwoDecimalDouble(double number)
        {
            double num = number;
            String fixedText = string.Format("{0:N2}", num);            
            try
            {
                num = double.Parse(fixedText);
            }
            catch (Exception)
            {
                Debug.Print("# Invalid input in function getTwoDecimalDouble(num) fixed string was " + fixedText);
                return -1;
            }
            return num;        
        }


        public static double getTwoDecimalDoubleOfStr(String str)
        {
            double num = -1;
            // First dot to , and parse..
            String fixedText = str.Replace(",", ".");
            try
            {
                // Make sure we use non cultural dependent way to get the number so it's consistent. ie . can mean different thing in some other culture. so now it should be more consistent in any platform.
                Boolean okay = double.TryParse(fixedText, NumberStyles.Any, CultureInfo.InvariantCulture, out num);  
            }
            catch (Exception)
            {
                Debug.Print("Invalid input probably in amount to pay field.. the test that was tried to parse as double was " + fixedText);
            }
            return getTwoDecimalDouble(num);
        }

        public static String getFileStr(string filePath, string commetMarker)
        {
            var lines = File.ReadAllLines(filePath);
            string combinedLines = "";
            foreach (var line in lines)
            {
                if (line.Length>0)
                    if (line.IndexOf("#")!=0)
                        combinedLines += line + Environment.NewLine;
            }
            return combinedLines;
        }



    }
}
