﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

// [Toni Sanio @2015]

namespace DebtAversion
{
    class Results
    {

        public static string resultFileName = "Results";
        public static string savingAllowedStrFolderPostfix = "_sa";
        public static string resultCBFileName = "Results_CB";
        public static string combinedResultFileName = "_Combined";
        public static string filePostFix = ".txt";
        public static string miscResultFileName = "MiscResults";
        public static string commentMarker = "#";

        public static string delimiter = "|";
        public static string delim = delimiter;

        public static String getTimestamp()
        {
            //Find unix timestamp (seconds since 01/01/1970)
            long ticks = DateTime.UtcNow.Ticks - DateTime.Parse("01/01/1970 00:00:00").Ticks;            
            ticks /= 10000000; //Convert windows ticks to seconds
            return ticks.ToString();            
        }

        public static String getConditionStr() {
            return (Properties.Settings.Default.popupMode + 1) + "";
        }

        public static Boolean pathExists(String path) {
            return System.IO.Directory.Exists(path);            
        }

        public static Boolean fileExists(String pathToFile)
        {
            return File.Exists(pathToFile);
        }

        public static String getResultPrefix()
        {
            return "";
        }

        public static String getMainResultsHeaderStr()
        {
            return commentMarker + "Subject Number" + delim + "debt name" + delim + getRoundsStr() + delim + "the amount of unpaid debt" + delim + "sum of total debt" + delim + "cash balance in 25 round" + delim + "Final total debt";
        }

        public static String getRoundsStr()
        {
            String roundsStr = "initial";
            for (int i = 0; i < Properties.Settings.Default.years; i++)
                roundsStr += delim + "round " + (i + 1);
            return roundsStr;
        }

        // Returns the folde ie. "1" or "1_sa" which means saving allowed.
        public static string getConditionFolderStr()
        {
            if (Properties.Settings.Default.allowMoneyLeftOver)
                return getConditionStr() + savingAllowedStrFolderPostfix;
            else
                return getConditionStr();
        }

        public static String getResultBasePath()
        {
            // Results Base Folder
            //string resultBasePath = AppDomain.CurrentDomain.BaseDirectory + "/Results/";
            string resultBasePath = Path.GetDirectoryName(Application.ExecutablePath) + "/Results/" + getConditionFolderStr() + "/";            
            if (!pathExists(resultBasePath))
                System.IO.Directory.CreateDirectory(resultBasePath);
            return resultBasePath;
        }

        public static void saveCurrentResults()
        {
            
            // Find next subject.            
            String id = Properties.Settings.Default.subjectNumber;
            string subjectPath = getResultBasePath() + id + "/";
            if (!pathExists(subjectPath))
            {
                System.IO.Directory.CreateDirectory(subjectPath);
            }
                        
            // File saving.. MISC
            using (System.IO.StreamWriter file = new System.IO.StreamWriter(subjectPath + miscResultFileName + getTimestamp() + filePostFix))
            {
                file.WriteLine("Subject " + Properties.Settings.Default.subjectNumber + " misc data:");
                file.WriteLine("Money leftover in the end: " + Account.getBalance());
                file.WriteLine("Money leftover allowed: " + Properties.Settings.Default.allowMoneyLeftOver);
                file.WriteLine("Popup Condition: " + getConditionStr());
                file.WriteLine("Years: " + Properties.Settings.Default.years);
                file.WriteLine("Year, Loan Number #, Loan Name, Amount Paid(" + Form1.currency + "), Loan Interest Rate (%), Loan Current Amont(" + Form1.currency + ")");
                foreach (PlanItem planItem in Plans.userPlans)
                    file.WriteLine(planItem.year + delimiter + planItem.chosenDebt.getIndex() + delimiter + planItem.chosenDebt.getName() + delimiter + planItem.amount + delimiter + planItem.chosenDebt.getInterestRate() + delimiter + planItem.chosenDebt.getAmountByYear(planItem.year));                
            }

            // File saving cash balance.
            // Put rest of the money for the total paid loans.
            using (System.IO.StreamWriter file = new System.IO.StreamWriter(subjectPath + getResultPrefix() + resultCBFileName + filePostFix))
            {
                string roundsCBStr = "";
                for (int i = 0; i < Properties.Settings.Default.years+1; i++)
                    roundsCBStr += Account.getHistoryOfYear(i)+delimiter;
                file.WriteLine(commentMarker + "Subject number" + delimiter + getRoundsStr() + delim);//+"(Note that round 5 player didn't receive money)" or does it mean last round?
                file.WriteLine(id + delimiter + roundsCBStr);
            }

            // Result information 1. Showing the amount of debt left per year for each debt. Note the prefix.
            using (System.IO.StreamWriter file = new System.IO.StreamWriter(subjectPath + getResultPrefix() + resultFileName + filePostFix))
            {
                file.WriteLine(getMainResultsHeaderStr());
                double debtSumLeft = 0f;
                int index = 0;
                foreach (Debt debt in Debts.debtList)
                {
                    if (index != 0)
                        file.WriteLine(); // Row each time except the first time. This is to show the total debt(+cash left etc) amount later in the last row last columns

                    String yearlyAmountsStr = "";
                    for (int i = 0; i < Properties.Settings.Default.years+1; i++)
                        yearlyAmountsStr += debt.getAmountByYear(i) + delimiter;
                    double unpaidDebtLastRound = debt.getAmountByYear(Properties.Settings.Default.years);
                    yearlyAmountsStr += unpaidDebtLastRound + delimiter; // Duplicate the last to show amount of unpaid debt
                    debtSumLeft += unpaidDebtLastRound;
                    file.Write(id + delim + debt.getName() + delim + yearlyAmountsStr);
                    index++;
                }
                // Add in the end of last row some important stuff..
                file.Write(debtSumLeft + delim + Account.getBalance() + delim + (debtSumLeft - Account.getBalance()));
            }
            
            // Combine all results from folders into one.
            combineAllResults();
        }


        public static void combineResults(string findFile, string resultFileName)
        {

            // Read all subject folders.
            string[] directories = Directory.GetDirectories(getResultBasePath());

            String subjectPath = "";
            String combinedStr = "";

            // Start making the file text for combined file..
            combinedStr += getMainResultsHeaderStr() + Environment.NewLine;

            foreach (string dir in directories) {                
                subjectPath = dir + "/";
                
                if (pathExists(subjectPath))
                {
                    string subjectResultFilePath = subjectPath + findFile;
                    if (fileExists(subjectResultFilePath))
                    {
                        combinedStr += Utils.getFileStr(subjectResultFilePath,commentMarker);
                    }
                }                
            }

            // Write it
            using (System.IO.StreamWriter file = new System.IO.StreamWriter(getResultBasePath() + resultFileName))
            {
                file.Write(combinedStr);
            }
        }

        public static void combineAllResults()
        {
            // Normal
            combineResults(resultFileName + filePostFix, resultFileName + combinedResultFileName + filePostFix);
            // Normal cash balance
            combineResults(resultCBFileName + filePostFix, resultCBFileName + combinedResultFileName + filePostFix);
        }
        
    }
}
 
