﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

// [Toni Sanio @2015]

namespace DebtAversion
{
    public partial class Popup : Form
    {
        public Popup()
        {
            InitializeComponent();
            refreshData();
        }

        Boolean quittinAlreadyStarted = false;
        Form1 form1Ref = null;
        public void setFormRef(Form1 reff) {
            form1Ref = reff;            
        }
        
        public void refreshData()
        {

            // Different conditions. Look from settings.
            int mode = Properties.Settings.Default.popupMode;
            int year = Form1.year;
            int years = Properties.Settings.Default.years;

            if (mode == ExperimentInfo.NORMAL_CONDITION || mode == ExperimentInfo.INTEGRATIVE_CONDITION)
            {        
                // Normal (or integrative mode)
                this.normalDataGridView.Rows.Clear();
                foreach (Debt debt in Debts.debtList)
                {
                    this.normalDataGridView.Rows.Add(debt.name, String.Format("{0:0.00}", debt.currentAmount) + Form1.currency, debt.interestRate + "%");
                }
                // Hide others show this.
                this.normalDataGridView.Visible = true;
                this.prospectiveDataGridView.Visible = false;
                this.retrospectiveDataGridView.Visible = false;
                // Set texts.
                setText(mode,year,years);
            }
            else if (mode == ExperimentInfo.PROSPECTIVE_CONDITION)
            {
                // Prospective
                this.prospectiveDataGridView.Rows.Clear();
                foreach (Debt debt in Debts.debtList)
                {
                    this.prospectiveDataGridView.Rows.Add(debt.name, String.Format("{0:0.00}", debt.currentAmount) + Form1.currency, debt.interestRate + "%", String.Format("{0:0.00}", debt.getThisYearCharge()) + Form1.currency);
                }
                // Hide others show this.
                this.prospectiveDataGridView.Visible = true;
                this.normalDataGridView.Visible = false;
                this.retrospectiveDataGridView.Visible = false;
                // Set texts.
                setText(mode,year,years);
            }
            else if (mode == ExperimentInfo.RETROPROSPECTIVE_CONDITION)
            {
                // Retrospective
                this.retrospectiveDataGridView.Rows.Clear();
                foreach (Debt debt in Debts.debtList)
                {
                    this.retrospectiveDataGridView.Rows.Add(debt.name, String.Format("{0:0.00}", debt.currentAmount) + Form1.currency, debt.interestRate + "%", String.Format("{0:0.00}", debt.getInterestChargesAllTogether()) + Form1.currency);
                }
                // Hide others show this.
                this.retrospectiveDataGridView.Visible = true;
                this.prospectiveDataGridView.Visible = false;
                this.normalDataGridView.Visible = false;
                // Set texts.
                setText(mode,year,years);
            }
            

                                               

        }

        public void setText(int mode, int year, int years)
        {
            // Rounds played
            caption1.Text = "YOU HAVE PLAYED " + year + " OF " + years + " ROUNDS";
            bonusLabel.Visible = false;
            if (mode == ExperimentInfo.NORMAL_CONDITION || mode == ExperimentInfo.INTEGRATIVE_CONDITION)
            {
                // Normal
                caption2.Text = "CURRENT DEBTS AND INTEREST RATES";
                rowInfoLbl.Text = "(1) Current Debt Amount, (2) Interest Rate.";

            }
            else if (mode == ExperimentInfo.PROSPECTIVE_CONDITION)
            {
                // Pro
                caption2.Text = "MAXIMUM DEBT INCREASE INFO";
                rowInfoLbl.Text = "(1) Current Debt Amount, (2) Interest Rate, (3) Max increase - the amount by which the debt would increase from this round to the next round if you allocate no cash to that particular debt.";
            }
            else
            {
                // Retro
                caption2.Text = "CURRENT DEBTS AND INTEREST CHARGES";
                rowInfoLbl.Text = "(1) Current Debt Amount, (2) Interest Rate, (3) Interest Charges - Accumulated interest charges for the debt.";
                double debtICSum = 0;
                foreach (Debt debt in Debts.debtList)
                    debtICSum += debt.getInterestChargesAllTogether();
                bonusLabel.Text = "Total interest charges (across debts) since beginning of game " + debtICSum + Form1.currency;
                bonusLabel.Visible = true;
            }

        }
        
        void Form2_FormClosed(object sender, FormClosedEventArgs e)
        {
            okayClickedOrFormClosed();
        }

        public void okayClickedOrFormClosed()
        {
            if (!quittinAlreadyStarted)
            {
                quittinAlreadyStarted = true;
                form1Ref.popUpClosed();
                this.Close();
            }
        }

        private void Form2_Load(object sender, EventArgs e)
        {
            this.CenterToScreen();
            this.FormClosed += new FormClosedEventHandler(Form2_FormClosed);
        }

        private void okayButton_Click(object sender, EventArgs e)
        {
            okayClickedOrFormClosed();
        }

    }
}
