﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

// [Toni Sanio @2015]

namespace DebtAversion
{
    public partial class MainDialog : Form
    {
        public MainDialog()
        {
            InitializeComponent();
        }

        public static Form1 form1;
        public static MainDialog maindialog;

        // CLose main window also when experiment window is closed ie. experiment end.
        public static void ExperimentFormClosed() {
            maindialog.Close();
        }

        private void MainDialog_Load(object sender, EventArgs e)
        {

            maindialog = this;
            this.CenterToScreen();

            // Moneyleftover
            allowMoneyLeftOverCB.Checked = Properties.Settings.Default.allowMoneyLeftOver;
            allowMoneyLeftOverCB.Text = "Allow unused cash " + Properties.Settings.Default.userMoneyInterestRate + " % yearly annual rate.";

            // Popup condition
            radioButton1.Checked = false;
            radioButton2.Checked = false;
            radioButton3.Checked = false;
            radioButton4.Checked = false;
            int condition = Properties.Settings.Default.popupMode;
            if (condition == 0) {
                radioButton1.Checked = true;
            } else if (condition == 1) {
                radioButton2.Checked = true;
            } else if (condition == 2) {
                radioButton3.Checked = true;
            } else if (condition == 3) {
                radioButton4.Checked = true;
            }                // ExperimentInfo contains also static variables 0-4 like ExperimentInfo.NORMAL_CONDITION 

        }

        public void applySettings()
        {
            // Moneyleftover
            Properties.Settings.Default.allowMoneyLeftOver = allowMoneyLeftOverCB.Checked;
            
            // Popup condition            
            if (radioButton1.Checked)
                Properties.Settings.Default.popupMode = 0;
            else if (radioButton2.Checked)
                Properties.Settings.Default.popupMode = 1;
            else if (radioButton3.Checked)
                Properties.Settings.Default.popupMode = 2;
            else if (radioButton4.Checked)
                Properties.Settings.Default.popupMode = 3;
            
            // Save subject number.
            Properties.Settings.Default.subjectNumber = subjectNumberTxt.Text;

            // SAVE!
            Properties.Settings.Default.Save();

        }

        Boolean areSettingsOkay()
        {
            int n;
            bool isNumericSubjectNumber = int.TryParse(subjectNumberTxt.Text, out n);

            if (subjectNumberTxt.Text == "" || !isNumericSubjectNumber)
            { 
                subjectNumberTxt.Text = "SUBJECT NUMBER HERE";
                MessageBox.Show("Insert subject number, please. Subject number must be numberical.");
                return false;
            }
            return true;
        }

        private void MainDialog_FormClosed(object sender, FormClosedEventArgs e)
        {
            Debug.Write("Close test..");
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (areSettingsOkay())
            {
                applySettings();
                form1 = new Form1();
                form1.Show();
                this.Hide(); // Cannot close main form! Just hide it.
            }            
        }

    }
}
