﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.DataVisualization.Charting;

// [Toni Sanio @2015]

namespace DebtAversion
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            //Load += Form1_Load;
        }
                
        private List<PlanItem> currentPlan = new List<PlanItem>();

        public static String currency = Properties.Settings.Default.currency;

        public static int years = Properties.Settings.Default.years;

        public static Boolean allowMoneyLeftOver = Properties.Settings.Default.allowMoneyLeftOver;

        public static int year = 0;

        public static double yearlyIncome = Properties.Settings.Default.yearlyIncome;

        public class ComboboxItem
        {
            public string Text { get; set; }
            public Debt Obj { get; set; }

            public override string ToString()
            {
                return Text;
            }
        }

        // CALL RESET WHEN STARTING EXPERIMENT.
        public static void updateConditions()
        {
            currency = Properties.Settings.Default.currency;
            years = Properties.Settings.Default.years;
            allowMoneyLeftOver = Properties.Settings.Default.allowMoneyLeftOver;
            yearlyIncome = Properties.Settings.Default.yearlyIncome;        
        }

        public void reset()
        {
            year = 0;
            Account.init();
            Debts.initDebts();
            Plans.init();
            currentPlan.Clear();
            updateConditions();
        }
                
        void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            MainDialog.ExperimentFormClosed();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

            this.BeginInvoke((MethodInvoker)delegate
            {
                this.hideThis();// Hide this after it had been initialized
            });

            this.CenterToScreen();

            reset();

            this.FormClosed += new FormClosedEventHandler(Form1_FormClosed);

            // Init charts
            refreshCharts();
            
            // Update minor things like currency text etc.
            currencyLbl.Text = currency;                       

            // Start year..
            startYear();

        }

      

        public void giveYearlyMoney()
        {
            
            Account.newYearStarted();
            
        }

        public void startNextYear()
        {
            year++;
            startYear();
        }

        public void showThis()
        {
            this.Show();
        }
        public void hideThis()
        {
            this.Hide();
        }

        public void startYear()
        {
            
            giveYearlyMoney();

            updateView();            
            
            showPopup();
                                    
        }
        
        public void updateTexts()
        {
            updateTotalDebtAmountText();
            updateYearsPlayedHeaderText();
            updateYearlyIncomeTexts();
            updateCurrentPositionTexts();                                   
        }

        public void updateTotalDebtAmountText()
        {
            totalDebtLbl.Text = Debts.totalDebtAmount() + " " + currency;
        }

        public Boolean allRoundsPlayed() {
            if (year < years)
                return false;
            return true;
        }

        public Boolean allRoundsPlayedInNextRound()
        {
            if (year < years-1)
                return false;
            return true;
        }


        public void updateYearsPlayedHeaderText()
        {
            if (!allRoundsPlayed())
                roundsLbl.Text = "Year " + (year + 1) + ". You have played " + year + " of " + years + " rounds.";
            else
                roundsLbl.Text = "You have played all " + years + " rounds.";
        }

        public void updateCurrentPositionTexts()
        {
            updateYearLabel();
        }

        public void updateYearlyIncomeTexts()
        {
            // General topic.
            yearlyIncomeAfterLbl.Text = "Yearly income (" + currency + ") after living expenses.";
            // Rounds played
            roundsPlayedLbl.Text = year + "";
            // All years
            totalRoundsLbl.Text = years+"";   
            // Fixed income
            fixedIncomeLbl.Text = yearlyIncome + " " + currency;
            // Bonus income
            bonusLbl.Text = Account.getLastGivenBonus() + " " + currency;            
            // Cash available (current amount)
            updateMoneyText(); 
        }

        public void updateMoneyText()
        {
            cashAvailableLbl.Text = String.Format("{0:0.00}", Account.getBalance()) + " " + currency;
        }
        public void popUpClosed()
        {
            showThis();
        }
        public void showPopup()
        {
            // Create a new instance of the Form2 class
            Popup debtInfoPopup = new Popup();

            debtInfoPopup.setFormRef(this);

            // Show the settings form
            debtInfoPopup.Show();

            hideThis();
        }

        public void updateYearLabel()
        {
            roundsPlayedLbl.Text = "" + year;
        }

        public void updateView()
        {
            // Update some graphs etc.
            refreshCharts();
            // Update other            
            updateTexts();
            updateAllocateCashPanel();
            updateAcceptButtonOutfit();
        }

        public void updateAllocateCashPanel()
        {
            // .. clearing..
            planListBox.Items.Clear();
            planListBox.Refresh();
            updatePlanView();
            updateComboBox();
            if (allRoundsPlayed())
                allocateCashPanel.Visible = false;
            else
                allocateCashPanel.Visible = true;
        }


        public void updatePlanView()
        {
            planListBox.Items.Clear();
            foreach (PlanItem planItem in currentPlan)
            {
                planListBox.Items.Add(planItem.chosenDebt.getName() + ": " + planItem.amount + currency);
            }
        }

        public double getCurrentPlanToPayForDebtAmount(Debt debt) {
            double payAmount = 0;
            foreach (PlanItem planItem in currentPlan)
            {
                if (planItem.chosenDebt == debt)
                    payAmount += planItem.amount;
            }
            return Utils.getTwoDecimalDouble(payAmount);
        }
        
        // The amount one is going to pay now for this particular dept in this year's plan.
        public double getValForCurrentPlan(Debt debt)
        {
            return Utils.getTwoDecimalDouble(debt.getCurrentAmount() - getCurrentPlanToPayForDebtAmount(debt));
        }

        public void updateComboBox() 
        {

            chooseDebtComboBox.Items.Clear();
            
            ComboboxItem lastChosenItem = null;

            // This last chosen thing doesn't work it doesn't choose really the correct item again.. bcos it's different now..
            if (chooseDebtComboBox.SelectedItem != null)
                lastChosenItem = (ComboboxItem)chooseDebtComboBox.SelectedItem;

            int i = 0;
            ComboboxItem firstItem=null;
            foreach (Debt debt in Debts.debtList)
            {
                ComboboxItem item = new ComboboxItem();
                if (debt.currentAmount>0)
                    item.Text = debt.getIndexStr() + ". " + debt.getName() + ": " + getValForCurrentPlan(debt) + currency;
                else
                    item.Text = debt.getIndexStr() + ". " + debt.getName() + ": PAID! ";

                item.Obj = debt;

                chooseDebtComboBox.Items.Add(item);
                if (i == 0)
                    firstItem = item;
                i++;

            }

            if (lastChosenItem == null && firstItem != null)
                lastChosenItem = firstItem; // First item if nothing has been selected yet.

            // Next time choose the previous chosen one..            
            if (lastChosenItem != null)
                chooseDebtComboBox.SelectedIndex = chooseDebtComboBox.Items.IndexOf(lastChosenItem);


        }
        
        public void refreshCharts()
        {
            debtChart.Series.Clear();
            
            foreach (Debt debt in Debts.debtList) {
                drawLineInChart(debt);
            }
            
        }

        public void drawLineInChart(Debt debt)
        {
            debtChart.Series.Add(debt.getIndexStr());
            debtChart.Series[debt.getIndexStr()].ChartType = SeriesChartType.Column;
            debtChart.Series[debt.getIndexStr()].LegendText = debt.getName();            
            int year = 0;            
            foreach (double val in debt.amountByYears)
            {
                debtChart.Series[debt.getIndexStr()].Points.AddXY(year, val);
                debtChart.Series[debt.getIndexStr()].Points.ElementAt(year).Color = debt.getColor();                                
                
                debtChart.Series[debt.getIndexStr()].Points.ElementAt(year).BorderWidth = 3;
                year++;
            }
            debtChart.Series[debt.getIndexStr()].ChartType = SeriesChartType.Line;
            debtChart.Series[debt.getIndexStr()].Color = debt.getColor();
            
        }
            
        
        // APPLY!
        private void button1_Click(object sender, EventArgs e)
        {
            applyPaymentToPlanList();
        }

        public void applyPaymentToPlanList()
        {
            // Check validity..
            double chosenAmount = Utils.getTwoDecimalDoubleOfStr(amount.Text);
            Debt chosenDebt = null;
            if (chooseDebtComboBox.SelectedItem != null)
                chosenDebt = ((ComboboxItem)(chooseDebtComboBox.SelectedItem)).Obj;
            try
            {
                if (chosenAmount > 0 && chosenAmount <= Account.getBalance() && chosenDebt != null && chosenDebt.isThisValidAmountToPay(getCurrentPlanToPayForDebtAmount(chosenDebt) + chosenAmount))
                {
                    currentPlan.Add(new PlanItem(chosenDebt, chosenAmount, year));
                    Account.charge(chosenAmount);
                }
                updateView();
                amount.Text = "";
            }
            catch (Exception)
            {
                Debug.Print("Some problem while adding to list of plans");
            }
        }
         
        public void removeSingleItemFromPlanListBox()
        {
            if (planListBox.SelectedIndex >= 0)
            {
                Account.add(currentPlan.ElementAt(planListBox.SelectedIndex).amount);
                currentPlan.RemoveAt(planListBox.SelectedIndex);
                planListBox.Items.Remove(planListBox.SelectedItem);
                planListBox.Refresh();
                updateView();
            }
        }

        private void resetPlanButton_Click(object sender, EventArgs e)
        {
            int i = 0;
            foreach (Object o in planListBox.Items)
            {
                PlanItem thisPlanItem = currentPlan[i];
                Account.add(thisPlanItem.amount); // Return the money..
                i++;
            }                           
            currentPlan.Clear();
            planListBox.Items.Clear();
            planListBox.Refresh();
            updateView();
        }

        private void payThisYearForDebts() {

            // First save plans for later statistic etc.
            foreach (PlanItem planItem in currentPlan)
                Plans.userPlans.Add(planItem);

            foreach (Debt debt in Debts.debtList) // Clear moneybuffer.
                debt.clearMoneyBuffer();

            foreach (PlanItem planItem in currentPlan)
                planItem.chosenDebt.addToMoneyBuffer(planItem.amount);
                        
            foreach (Debt debt in Debts.debtList) // Add all.. Even those that didn't have plan to pay so they will add one nice clean clear point in the graph.
                debt.jumpToNextYearUseMoneyBuffer();

            currentPlan.Clear();
        }

        
        private Boolean paymentLegit()
        {
            if (allowMoneyLeftOver || Debts.allDebtsPaid())
            {
                return true;
            }
            else
            {
                if (Account.getBalance() > 0)
                {
                    return false;
                }
                return true;
            }

        }

        private void updateAcceptButtonOutfit()
        {
            if (paymentLegit())
                acceptPlanButton.BackColor = Color.FromArgb(10,0,255,0);
            else
                acceptPlanButton.BackColor = Color.Transparent;
        }

        private void acceptPlanButton_Click(object sender, EventArgs e)
        {            
                if (paymentLegit()&&!allRoundsPlayed())
                {
                    // Ye pay pay ..
                    payThisYearForDebts();

                    if (!allRoundsPlayedInNextRound()) {                    
                        // Give £££€€, raise the debt amounts and update view.
                        startNextYear();
                    } else {
                        // Experiment over last paid round!
                        year++; // The final tick
                        experimentOver();                
                    }
                }
                else
                {
                    Debug.Write("There is still money left " + Account.getBalance());
                    MessageBox.Show("You have to use all your money!");
                }                            
                      
        }
        
        // Put all money into this chosen debt
        private void allButton_Click(object sender, EventArgs e)
        {
            useAllMoneyForSelectedDebt();
        }
        public void useAllMoneyForSelectedDebt()
        {
            try
            {
                // Check validity..
                Debt chosenDebt = null;
                if (chooseDebtComboBox.SelectedItem != null)
                    chosenDebt = ((ComboboxItem)(chooseDebtComboBox.SelectedItem)).Obj;
                if (chosenDebt != null)
                {
                    double neededAmountToPayWholeDept = Utils.getTwoDecimalDouble(chosenDebt.currentAmount - getCurrentPlanToPayForDebtAmount(chosenDebt));
                    double amountToPay = neededAmountToPayWholeDept;
                    if (amountToPay > Account.getBalance())
                        amountToPay = Account.getBalance();
                    amount.Text = amountToPay + "";
                }
            }
            catch
            {

            }            
            
        }

        public void experimentOver()
        {
            // Experiment ends.. New year not yet started.. Save the current amount of cash in the history though for printing out.
            Account.saveThisRoundHistory();        

            Results.saveCurrentResults();
            updateView(); // That's it
        }

        private void chooseDebtComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            useAllMoneyForSelectedDebt();
        }

        private void amount_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                applyPaymentToPlanList();
                e.Handled = true; // Avoid ding sound
                e.SuppressKeyPress = true;
            }
        }



       


        


    }
}
