﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// [Toni Sanio @2015]

namespace DebtAversion
{
    // Static class that contains all the debts and can be accessed from anywhere.
    public class Debts
    {
        public static List<Debt> debtList = new List<Debt>();
        
        public static int currentIndex = 0;        

        public static void initDebts() {
            debtList.Clear();
            currentIndex = 0;

            int counter = 0;
            string line;

            string loanFileName = "Loans.txt";
            if (Properties.Settings.Default.popupMode == 3) // Integrative mode switched loans to be read from another file.
                loanFileName = "LoansICondition.txt";

            // Read the file and copy loan data line by line.
            System.IO.StreamReader file = new System.IO.StreamReader(AppDomain.CurrentDomain.BaseDirectory + loanFileName);

            while ((line = file.ReadLine()) != null)
            {
                //Console.WriteLine(line);
                String[] cols = line.Split(',');
                try
                {
                    Console.Write(cols[0] + " - " + double.Parse(cols[1].Trim(), CultureInfo.InvariantCulture) + " - " + double.Parse(cols[2].Trim(), CultureInfo.InvariantCulture));
                    if (cols.Count() > 2)
                        debtList.Add(new Debt(cols[0], double.Parse(cols[1].Trim(), CultureInfo.InvariantCulture), double.Parse(cols[2].Trim(), CultureInfo.InvariantCulture)));


                } catch(Exception e) {
                    Console.Write("Problem while reading file. " + e);
                }
                counter++;
            }

            file.Close();
            
            Random rnd = new Random();
            foreach (Debt debt in debtList)
            {                
                debt.setColor(Color.FromArgb(255, rnd.Next(255), rnd.Next(255), rnd.Next(255)));
            }
        }

        public static Boolean allDebtsPaid()
        {
            if (totalDebtAmount() > 0d)
                return false;
            return true;
        }

        public static double totalDebtAmount()
        {
            double result = 0d;
            foreach (Debt debt in debtList)
                if (debt.currentAmount > 0)
                    result += debt.getCurrentAmount();
            return result;
        }

        public static int getNextIndex()
        {
            currentIndex++;
            return currentIndex;
        }


    }
}
