﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// [Toni Sanio @2015]

namespace DebtAversion
{
    public class Debt
    {
        public double currentAmount;
        public double originalAmount;
        public double interestRate;
        public String name;

        public Color color;
        public int index;

        public double moneyBuffer;

        public List<double> interestCharges = new List<double>();
        public List<double> amountByYears = new List<double>();

        public void init(String name, double amount, double interestRate)
        {
            Random rnd = new Random();
            this.name = name;
            this.currentAmount = amount;
            this.originalAmount = amount;
            this.interestRate = interestRate;
            this.amountByYears.Add(currentAmount);
            this.color = Color.FromArgb(255, rnd.Next(255), rnd.Next(255), rnd.Next(255));
            this.index = Debts.getNextIndex();
        }


        public void clearMoneyBuffer()
        {
            moneyBuffer = 0;
        }

        public void addToMoneyBuffer(double moneyToAdd)
        {
            moneyBuffer += moneyToAdd;
        }

        public double getMoneyBuffer()
        {
            return moneyBuffer;
        }

        public String getName()
        {
            return name;
        }

        public void setIndex(int index)
        {
            this.index = index;
        }

        public int getIndex()
        {
            return this.index;
        }

        public String getIndexStr()
        {
            return this.index.ToString();
        }

        public double getCurrentAmount()
        {
            return Utils.getTwoDecimalDouble(this.currentAmount);
        }

        public void setColor(Color toColor)
        {
            this.color = toColor;        
        }
        public Color getColor()
        {
            return this.color;
        }

        public Debt(String name, double amount, double interestRate)
        {
            init(name, amount, interestRate);
        }

        public Debt(double amount, double interestRate) 
        {
            init("noname", amount, interestRate);
        }

        public Boolean isThisValidAmountToPay(double amount)
        {
            if (Utils.getTwoDecimalDouble(amount) > Utils.getTwoDecimalDouble(currentAmount) || amount < 0)
                return false;
            return true;
        }

        // Returns the percentage ie. 1% = 1.01f 
        public double getInterestRateMultiplier() 
        {
            return ((interestRate * 0.01d) + 1.0d);
        }

        public void jumpToNextYearUseMoneyBuffer()
        {
            jumpToNextYear(moneyBuffer);
        }

        public double getThisYearCharge()
        {
            return (currentAmount * getInterestRateMultiplier()) - currentAmount;
        }

        public double getInterestChargesAllTogether()
        {
            double sum = 0;
            foreach (double f in interestCharges)
                sum += f;
            return Utils.getTwoDecimalDouble(sum);
        }

        public double getInterestRate()
        {
            return interestRate;
        }

        public double getAmountByYear(int year)
        {
            double res = 0;
            try
            {
                res = Utils.getTwoDecimalDouble(amountByYears.ElementAt(year));
            }
            catch (Exception e)
            {
                Console.Write("!!ERROR reading from amountByYears-array! " +e);
            }
            return res;
        }

        public int yearWhenAllWasPaid()
        {
            int cYear=0;
            foreach (double stillLeftThisYear in amountByYears)
            {
                if (stillLeftThisYear <= 0)
                    return cYear;
                cYear++;
            }
            return -1;
        }

        // Jumpst to next year and pays the amount of the debt.
        public void jumpToNextYear(double amount)
        {
            
            // Decrease the paid amount from the loan first.
            currentAmount -= amount;

            if (currentAmount > 0)
            {
                // There is still something left after payment. Charge according left amount and interest rate.
                interestCharges.Add(getThisYearCharge()); 
                
                // Raise the amount of loan to higher according interest rate.
                currentAmount *= getInterestRateMultiplier();

                // Round the current amount to two decimal number to make it easier to handle later.
                currentAmount = Utils.getTwoDecimalDouble(currentAmount);
                                
            } else { 
                // Debt paid! \o/ FREE! <3 :)
                currentAmount = 0;
            }

            // Keep track of the loan amount per year. (Also already paid will be seen as zero in history)
            amountByYears.Add(currentAmount);

        }

        
        
    }
}
