﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// [Toni Sanio @2015]

namespace DebtAversion
{
    class Account
    {
        // Static account. One per application.

        static double currentAmount = 0d;
        static List<double> history = new List<double>();

        static double lastGivenBonus = 0;

        static public double getLastGivenBonus()
        {
            return lastGivenBonus;
        }

        public static void init()
        {
            currentAmount = 0;
            history.Clear();
        }

        // This may need some fine tuning..
        public static void newYearStarted()
        {

            int year = history.Count;
            double bonusIncome = 0f;
            
            // Sometimes bonus.
            if (year + 1 == 6)
                bonusIncome = 20000;
            if (year + 1 == 12)
                bonusIncome = 15000;
            if (year + 1 == 19)
                bonusIncome = 40000;

            // Save for the record.
            lastGivenBonus = bonusIncome;
            
            // The old money will grow first if there was left over usually with 2% interest rate.
            currentAmount *= ((Properties.Settings.Default.userMoneyInterestRate * 0.01f) + 1.0f);
            currentAmount += 5000;
            currentAmount += bonusIncome;

            // Round the number to two decimal.
            currentAmount = Utils.getTwoDecimalDouble(currentAmount);

            // Save the history.. This way the 0 can be default and then there is this 5000 as default value in the first column as wished.
            // So this balance means that what is the status of the cash balance in the beginning of year after the player had received money.
            saveThisRoundHistory(); // Exceptionally though the last year.. when the year had ended the amount of money is recorded to be able to register it and decrease it from the last unpaid debt amount.

        }

        public static void add(double amount)
        {
            currentAmount += amount;
        }

        public static double getBalance()
        {
            return Utils.getTwoDecimalDouble(currentAmount);
        }

        public static double getHistoryOfYear(int year)
        {
            if (year < history.Count)
                return history.ElementAt(year);
            return -1;
        }

        public static Boolean charge(double amount)
        {
            if (Utils.getTwoDecimalDouble(amount) > Utils.getTwoDecimalDouble(currentAmount)) { 
                Console.Write("Error > Tried to take more money than possible. continuing..");
                currentAmount = 0;
            } else
                currentAmount -= amount;

            return true;            
        }       

        public static void saveThisRoundHistory()
        {
            history.Add(getBalance());
        }

    }
}
