/*
 * Decompiled with CFR 0.152.
 */
package roundclock24;

import java.awt.AWTException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import roundclock24.ClockPanel;

public class RoundClock24
extends JFrame {
    KeyboardFocusManager keyManager;
    Point mouseDownCompCoords = null;
    TrayIcon trayIcon;
    SystemTray tray;
    String appName = "24HourClock";
    ClockPanel clockPanel;

    public RoundClock24() {
        super("ShapedWindow");
        this.setType(Window.Type.UTILITY);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Unable to set LookAndFeel");
        }
        if (SystemTray.isSupported()) {
            System.out.println("system tray supported");
            this.tray = SystemTray.getSystemTray();
            ImageIcon clockIcon = new ImageIcon(this.getClass().getClassLoader().getResource("res/clockicon.png"));
            Image image = RoundClock24.iconToImage(clockIcon);
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RoundClock24.this.setVisible(true);
                    RoundClock24.this.setExtendedState(0);
                }
            };
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem("Open");
            defaultItem.addActionListener(exitListener);
            popup.add(defaultItem);
            defaultItem = new MenuItem("Exit");
            defaultItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Exiting....");
                    System.exit(0);
                }
            });
            popup.add(defaultItem);
            this.trayIcon = new TrayIcon(image, this.appName, popup);
            this.trayIcon.setImageAutoSize(true);
            ActionListener doubleClickOpenListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RoundClock24.this.setVisible(true);
                    RoundClock24.this.setExtendedState(0);
                }
            };
            this.trayIcon.addActionListener(doubleClickOpenListener);
        } else {
            System.out.println("system tray not supported");
        }
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 1) {
                    RoundClock24.this.hideToTray();
                }
                if (e.getNewState() == 7) {
                    RoundClock24.this.hideToTray();
                }
                if (e.getNewState() == 6) {
                    RoundClock24.this.removeFromTray();
                }
                if (e.getNewState() == 0) {
                    RoundClock24.this.removeFromTray();
                }
            }
        });
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("res/clockicon.png"));
        this.keyManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyManager.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getID() == 401 && e.getKeyCode() == 27) {
                    RoundClock24.this.minimize();
                    return true;
                }
                return false;
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RoundClock24.this.setShape(new Ellipse2D.Double(0.0, 0.0, RoundClock24.this.getWidth(), RoundClock24.this.getHeight()));
            }
        });
        RoundClock24 thisJFrme = this;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                RoundClock24.this.mouseDownCompCoords = null;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RoundClock24.this.mouseDownCompCoords = e.getPoint();
                if (e.getClickCount() >= 2) {
                    RoundClock24.this.minimize();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Point currCoords = e.getLocationOnScreen();
                if (RoundClock24.this.mouseDownCompCoords != null) {
                    RoundClock24.this.setLocation(currCoords.x - RoundClock24.this.mouseDownCompCoords.x, currCoords.y - RoundClock24.this.mouseDownCompCoords.y);
                }
            }
        });
        this.setUndecorated(true);
        this.setSize(300, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.clockPanel = new ClockPanel(this);
        this.add(this.clockPanel);
    }

    public void minimize() {
        this.setState(1);
        this.clockPanel.stopTimer();
    }

    public void hideToTray() {
        try {
            this.tray.add(this.trayIcon);
            this.setVisible(false);
            System.out.println("added to SystemTray");
        }
        catch (AWTException ex) {
            System.out.println("unable to add to tray");
        }
    }

    public void removeFromTray() {
        this.clockPanel.startTimer();
        try {
            this.tray.remove(this.trayIcon);
            this.setVisible(true);
            System.out.println("Tray icon removed");
        }
        catch (Exception e) {
            System.out.println("unable to remove from tray");
        }
    }

    public boolean isVisbible() {
        return this.isShowing();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static void main(String[] args) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        final boolean isTranslucencySupported = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
        if (!gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT)) {
            System.err.println("Shaped windows are not supported");
            System.exit(0);
        }
        if (!isTranslucencySupported) {
            System.out.println("Translucency is not supported, creating an opaque window");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RoundClock24 sw = new RoundClock24();
                if (isTranslucencySupported) {
                    sw.setOpacity(0.7f);
                }
                sw.setVisible(true);
            }
        });
    }

    static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }
}

