/*
 * Decompiled with CFR 0.152.
 */
package roundclock24;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Calendar;
import javax.swing.JPanel;
import javax.swing.Timer;
import roundclock24.RoundClock24;

public class ClockPanel
extends JPanel {
    RoundClock24 roundClockRef;
    Timer timer;

    public ClockPanel(final RoundClock24 roundClockRef) {
        this.roundClockRef = roundClockRef;
        this.setOpaque(true);
        ActionListener timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (roundClockRef != null && roundClockRef.isVisbible()) {
                    ClockPanel.this.repaint();
                }
            }
        };
        this.timer = new Timer(41, timerAction);
        this.timer.setRepeats(true);
        this.startTimer();
        this.setBackground(Color.BLACK);
    }

    public void startTimer() {
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    protected int getRadius() {
        return Math.min(this.getWidth(), this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawClock(g);
    }

    public void drawClock(Graphics g) {
        Color photonColor = new Color(40, 80, 255, 255);
        g.setColor(photonColor);
        int amountOfHours = 24;
        double radius = (double)this.getWidth() * 0.45;
        Font font = new Font("Verdana", 1, 12);
        for (int i = 0; i < amountOfHours; ++i) {
            double angle = Math.PI * 2 / (double)amountOfHours * (double)i;
            double x = (double)this.getWidth() / 2.0 + Math.cos(angle -= 1.5707963267948966) * radius;
            double y = (double)this.getHeight() / 2.0 + Math.sin(angle) * radius;
            int hourNumeric = i;
            if (i == 0) {
                hourNumeric = 24;
            }
            this.drawCenteredString(g, "" + hourNumeric, x, y, font);
            double x1 = (double)this.getWidth() / 2.0 + Math.cos(angle) * radius * 0.9;
            double y1 = (double)this.getHeight() / 2.0 + Math.sin(angle) * radius * 0.9;
            double x2 = (double)this.getWidth() / 2.0 + Math.cos(angle) * radius * 0.8;
            double y2 = (double)this.getHeight() / 2.0 + Math.sin(angle) * radius * 0.8;
            g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        }
        Calendar rightNow = Calendar.getInstance();
        long offset = rightNow.get(15) + rightNow.get(16);
        long sinceMidnightMs = (rightNow.getTimeInMillis() + offset) % 86400000L;
        double sinceMidNightSec = (double)sinceMidnightMs / 1000.0;
        double sinceMidNightMin = sinceMidNightSec / 60.0;
        double sinceMidNightHour = sinceMidNightMin / 60.0;
        double hourN = sinceMidNightHour / 24.0;
        double minN = sinceMidNightMin / 60.0;
        double secN = sinceMidNightSec / 60.0;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(photonColor);
        this.drawClockLine(g, hourN, radius * 0.5, 4);
        g.setColor(photonColor);
        this.drawClockLine(g, minN, radius * 0.75, 3);
        g.setColor(photonColor);
        this.drawClockLine(g, secN, radius * 0.8, 1);
        Graphics2D g2 = (Graphics2D)g;
        int circleThick = 3;
        g2.setStroke(new BasicStroke(circleThick));
        Ellipse2D.Double hole = new Ellipse2D.Double();
        hole.width = this.getWidth();
        hole.height = this.getHeight();
        hole.x = 0.0;
        hole.y = 0.0;
        g2.draw(hole);
    }

    void drawClockLine(Graphics g, double normalizedValue, double radius, int thickness) {
        double angleRad = normalizedValue * Math.PI * 2.0;
        double x = (double)this.getWidth() / 2.0 + Math.cos(angleRad -= 1.5707963267948966) * radius;
        double y = (double)this.getHeight() / 2.0 + Math.sin(angleRad) * radius;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(thickness));
        g2.draw(new Line2D.Float((int)((double)this.getWidth() / 2.0), (int)((double)this.getHeight() / 2.0), (int)x, (int)y));
    }

    public void drawCenteredString(Graphics g, String text, double x_, double y_, Font font) {
        FontMetrics metrics = g.getFontMetrics(font);
        int x = (int)(x_ - (double)(metrics.stringWidth(text) / 2));
        int y = (int)(y_ - (double)(metrics.getHeight() / 2)) + metrics.getAscent();
        g.setFont(font);
        g.drawString(text, x, y);
    }
}

